package gov.va.med.domain.model;

import java.util.Date;
import java.util.Set;

import org.apache.commons.lang3.builder.ToStringBuilder;


/** 
 *        @hibernate.class
 *         table="PATIENT_MESSAGING_REQUESTS"
 *     
*/
public class PatientMessagingRequest extends DomainObject {

    /** persistent field */
    private String icn;

    /** persistent field */
    private Long userId;

    /** persistent field */
    private gov.va.med.domain.model.Function function;

    /** persistent field */
    private Set messagingRequests;

    /** full constructor */
    public PatientMessagingRequest(String icn, Long userId, Date createdDate, gov.va.med.domain.model.Function function, Set messagingRequests) {
        this.icn = icn;
        this.userId = userId;
        setCreatedDate(createdDate);
        this.function = function;
        this.messagingRequests = messagingRequests;
    }

    /** default constructor */
    public PatientMessagingRequest() {
    }

    /** 
     *            @hibernate.property
     *             column="ICN"
     *             length="20"
     *             not-null="true"
     *         
     */
    public String getIcn() {
        return this.icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    /** 
     *            @hibernate.property
     *             column="USER_ID_SEQ"
     *             not-null="true"
     *         
     */
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    /** 
     *            @hibernate.many-to-one
     *             not-null="true"
     *            @hibernate.column name="FUNCTION_ID_SEQ"         
     *         
     */
    public gov.va.med.domain.model.Function getFunction() {
        return this.function;
    }

    public void setFunction(gov.va.med.domain.model.Function function) {
        this.function = function;
    }

    /** 
     *            @hibernate.set
     *             lazy="true"
     *             inverse="true"
     *             cascade="none"
     *            @hibernate.collection-key
     *             column="PATIENT_MESSAGING_RQST_ID_SEQ"
     *            @hibernate.collection-one-to-many
     *             class="gov.va.med.domain.model.MessagingRequest"
     *         
     */
    public Set getMessagingRequests() {
        return this.messagingRequests;
    }

    public void setMessagingRequests(Set messagingRequests) {
        this.messagingRequests = messagingRequests;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("id", getId())
            .toString();
    }

}
